#include <p30fxxxx.h>
#include <outcompare.h>

/* This devices support OutputCompare 5 thru OutputCompare 8 */
#if defined(__dsPIC30F6010__) || defined(__dsPIC30F5011__) || defined(__dsPIC30F6011__) || \
    defined(__dsPIC30F6012__) || defined(__dsPIC30F5013__) || defined(__dsPIC30F6013__) || \
    defined(__dsPIC30F6014__)

/********************************************************************
*    Function Name:  SetDCOC7PWM                                    *
*    Description:    This routine writes the duty cycle OCRS reg    *
*    Parameters:     unsigned int duty cycle                        *
*    Return Value:   None                                           *
********************************************************************/

void  SetDCOC7PWM(unsigned int dutycycle)
{   
    /* check OC is in PWM Mode.*/
    if((OC7CONbits.OCM & 0x06) == 0x06) 
       OC7RS = dutycycle; /* assign to OCRS */
}

#endif
